<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

trait TraitPostProperties
{
    // primary key

    /**
     * @var string
     */
    protected $id;

    // ids

    /**
     * @var string
     */
    protected $ownerUserId;

    // display

    /**
     * @var string
     */
    protected $displayCaption;

    /**
     * @var string
     */
    protected $displayLocation;

    /**
     * @var PostDisplayContentDTO
     */
    protected $displayContent;

    // meta

    /**
     * @var PostMetaHashtagsDTO
     */
    protected $metaHashtags;

    // cache

    /**
     * @var string
     */
    protected $cacheLikesCount;

    /**
     * @var string
     */
    protected $cacheCommentsCount;

    // stamps

    /**
     * @var string
     */
    protected $stampRegistration;

    /**
     * @var string
     */
    protected $stampLastUpdate;
}
